#! /bin/sh

BIN_DIR="/usr/local/dingtone"
VAR_DIR="/var/dingtone"
ETC_DIR="/etc/dingtone"
VAR_LOG_DIR="/var/log/dingtone"

if [ $UID -ne 0 ]; then
    echo "Root privileges are required to run this script."
    echo "e.g. \"sudo $0\""
    exit 1
fi

if [ -d "$BIN_DIR" ]; then
  echo "${BIN_DIR} existing"
else
  echo "mkdir ${BIN_DIR}"
  mkdir $BIN_DIR
fi

if [ -d "$VAR_DIR" ]; then
  echo "${VAR_DIR} existing"
else
  echo "mkdir ${VAR_DIR}"
  mkdir $VAR_DIR
fi

if [ -d "$ETC_DIR" ]; then
  echo "${ETC_DIR} existing"
else
  echo "mkdir ${ETC_DIR}"
  mkdir $ETC_DIR
fi

if [ -d "$VAR_LOG_DIR" ]; then
  echo "${VAR_LOG_DIR} existing"
else
  echo "mkdir ${VAR_LOG_DIR}"
  mkdir $VAR_LOG_DIR
fi

#update kernel first
#sudo yum update -y
sudo yum install -y glibc
sudo yum install -y net-tools
sudo yum install -y bind-utils
sudo yum install -y ethtool
sudo yum install -y wget
sudo yum install -y gdb
sudo yum install -y zip
sudo yum install -y unzip
sudo yum install -y perf
sudo yum install -y iotop
sudo yum install -y iptables-services
sudo yum install epel-release -y
sudo yum install -y iperf
sudo yum install -y mtr
 
sudo chkconfig crond on
sudo service  crond    start
sudo service  sendmail stop
sudo service  postfix  stop

sudo systemctl mask firewalld
sudo systemctl enable iptables
sudo systemctl enable ip6tables
sudo systemctl stop firewalld
sudo systemctl start iptables
sudo systemctl start ip6tables

	sudo iptables -L
	sudo iptables -F
	sudo iptables -X
	sudo iptables -Z

	sudo iptables -F -t nat
	sudo iptables -X -t nat
	sudo iptables -Z -t nat
	sudo iptables -L -t nat
	
	sudo service iptables save
	
if [ -n "$2" ]; then
	echo "config iptable : ${2}, check /etc/sysconfig/iptables"
	#config iptables if without cloud-firewall


	sudo iptables -A INPUT -m state --state RELATED,ESTABLISHED -j ACCEPT
	sudo iptables -A OUTPUT  -m state --state RELATED,ESTABLISHED -j ACCEPT
   		 #open 22(ssh) port for tcp
	sudo iptables -A INPUT -p tcp -m tcp --dport 22 -j ACCEPT
		#8090 is the dtvpnclient port
		
	sudo iptables -A INPUT -p tcp -m tcp --dport 8080 -j ACCEPT
	sudo iptables -A INPUT -p tcp -m tcp --dport 8088 -j ACCEPT
	sudo iptables -A INPUT -p tcp -m tcp --dport 8089 -j ACCEPT
    sudo iptables -A INPUT -p tcp -m tcp --dport 8090 -j ACCEPT
    sudo iptables -A INPUT -p tcp -m tcp --dport 8800 -j ACCEPT
	sudo iptables -A INPUT -p tcp -m tcp --dport 8888 -j ACCEPT
    
    sudo iptables -A INPUT -p tcp -m tcp --dport 80 -j ACCEPT
    sudo iptables -A INPUT -p tcp -m tcp --dport 443 -j ACCEPT
    sudo iptables -A INPUT -p tcp -m tcp --dport 21 -j ACCEPT
    sudo iptables -A INPUT -p tcp -m tcp --dport 53 -j ACCEPT
    sudo iptables -A INPUT -p tcp -m tcp --dport 4430 -j ACCEPT
    
	sudo iptables -A INPUT -p udp -m udp --dport 4500 -j ACCEPT
	sudo iptables -A INPUT -p udp -m udp --dport 500 -j ACCEPT
	sudo iptables -A INPUT -p udp -m udp --dport 4501 -j ACCEPT
	sudo iptables -A INPUT -p udp -m udp --dport 501 -j ACCEPT
	sudo iptables -A INPUT -p udp -m udp --dport 4502 -j ACCEPT
	sudo iptables -A INPUT -p udp -m udp --dport 502 -j ACCEPT
	
	    	#6180 is ping port at vpn network, should change to other port in future
    sudo iptables -A INPUT -p udp -m udp --dport 6180 -j ACCEPT
		#3799 is the strongswan listen port that receive Disconnect instructions from Radius server
	sudo iptables -A INPUT -p udp -m udp --dport 3799 -j ACCEPT
		#123 is ntpd service port
	sudo iptables -A INPUT -p udp -m udp --dport 123 -j ACCEPT
	sudo iptables -A INPUT -p udp -m udp --dport 53 -j ACCEPT
		#allow ping from outside
	sudo iptables -A INPUT -p icmp -j ACCEPT
	
		#将input链默认规则设置为丢弃
	sudo iptables -P INPUT DROP
	
	#disable common ports for BitBorrent
	sudo iptables -A INPUT -p udp --dport 6881:6969 -j DROP
	sudo iptables -A INPUT -p tcp --dport 6881:6969 -j DROP
	sudo iptables -A INPUT -p udp --dport 8881:8889 -j DROP
	sudo iptables -A INPUT -p tcp --dport 8881:8889 -j DROP
	sudo iptables -A INPUT -p udp --dport 16881:16889 -j DROP
	sudo iptables -A INPUT -p tcp --dport 16881:16889 -j DROP
	
 	sudo iptables -A OUTPUT -p udp --dport 6881:6969 -j DROP
	sudo iptables -A OUTPUT -p tcp --dport 6881:6969 -j DROP
	sudo iptables -A OUTPUT -p udp --dport 8881:8889 -j DROP
	sudo iptables -A OUTPUT -p tcp --dport 8881:8889 -j DROP
	sudo iptables -A OUTPUT -p udp --dport 16881:16889 -j DROP
	sudo iptables -A OUTPUT -p tcp --dport 16881:16889 -j DROP
 
	sudo iptables -A FORWARD -p udp --dport 6881:6969 -j DROP
	sudo iptables -A FORWARD -p tcp --dport 6881:6969 -j DROP
	sudo iptables -A FORWARD -p udp --dport 8881:8889 -j DROP
	sudo iptables -A FORWARD -p tcp --dport 8881:8889 -j DROP
	sudo iptables -A FORWARD -p udp --dport 16881:16889 -j DROP
	sudo iptables -A FORWARD -p tcp --dport 16881:16889 -j DROP

	#disable protocol about BitBorrent at FORWARD chain
	sudo iptables -A FORWARD -m string --string "BitTorrent" --algo bm --to 65535 -j DROP
	sudo iptables -A FORWARD -m string --string "BitTorrent protocol" --algo bm --to 65535 -j DROP
	sudo iptables -A FORWARD -m string --string ".torrent" --algo bm --to 65535 -j DROP
	sudo iptables -A FORWARD -m string --string "torrent" --algo bm --to 65535 -j DROP

    #disable protocol about BitBorrent at OUTPUT chain
	sudo iptables -A OUTPUT -m string --string "BitTorrent" --algo bm --to 65535 -j DROP
	sudo iptables -A OUTPUT -m string --string "BitTorrent protocol" --algo bm --to 65535 -j DROP
	sudo iptables -A OUTPUT -m string --string ".torrent" --algo bm --to 65535 -j DROP
	sudo iptables -A OUTPUT -m string --string "torrent" --algo bm --to 65535 -j DROP

	#force rewrite MSS to 1360,so that client and host can pass through VPN Server
	sudo iptables -t mangle -A FORWARD -o eth0  -p tcp -m tcp --tcp-flags SYN,RST SYN -m tcpmss --mss 1361:1536 -j TCPMSS --set-mss 1360
	#if have other eth network card(eth1,eth2)
	#sudo iptables -t mangle -A FORWARD -o eth1  -p tcp -m tcp --tcp-flags SYN,RST SYN -m tcpmss --mss 1361:1536 -j TCPMSS --set-mss 1360
	#sudo iptables -t mangle -A FORWARD -o eth2  -p tcp -m tcp --tcp-flags SYN,RST SYN -m tcpmss --mss 1361:1536 -j TCPMSS --set-mss 1360

	#	sudo iptables -t nat -A POSTROUTING -s ${1} -j SNAT --to-source ${2}
	
	sudo service iptables save
 
	sudo iptables -L -n
	sudo iptables -L -t nat -n
else
	echo "Please maksure cloud-firewall already setup"
fi

#modify mtu
sudo iptables -t mangle -A FORWARD -o eth0  -p tcp -m tcp --tcp-flags SYN,RST SYN -m tcpmss --mss 1361:1536 -j TCPMSS --set-mss 1360
sudo service iptables save

sudo cp /usr/share/zoneinfo/UTC /etc/localtime -f 
	#启动ntpd时钟同步 
	#sudo yum -y install ntp
	#sudo chkconfig ntpd on
	#sudo service ntpd start
	
#安装 dingtone-xedge 服务 +  xedge-monitor	
	#echo "downloading vpn files"
	#scp $1:/root/deploy/dtvpn/install-xedge-vpn.zip ~
	#unzip /tmp/install-xedge-vpn.zip
	#rm -f ./install-xedge-vpn.zip
	
        echo "\n"
        echo "\n"
        echo "\n"
	echo "dingtone-xedge->/etc/init.d/"
	mv  ./dingtone-xedge /etc/init.d/
	sudo chkconfig  dingtone-xedge on
	ls /etc/init.d/dingtone-xedge -l 
	
        echo "\n"
        echo "\n"
        echo "\n"
	echo "xedge-monitor->/usr/local/dingtone/"
	mv ./xedge-monitor $BIN_DIR
	ls $BIN_DIR/xedge-monitor -l 

	mv ./ssl_*.pem		$BIN_DIR
	mv ./*.crt          $BIN_DIR
	
	
        echo "\n"
        echo "\n"
        echo "\n"
	echo "xedge-config.xml ->/etc/dingtone"
	mv ./xedge-config.xml $ETC_DIR
 	mv ./small-xedge-config.xml $ETC_DIR
	mv ./full-xedge-config.xml $ETC_DIR
	ls $ETC_DIR/xedge-config.xml -l 
	
	echo "\n"
	echo "\n"
	echo "\n"	
	cat /etc/sysctl.conf
	echo "sysctl.conf -> /etc"
	sleep 5
	cp  /etc/sysctl.conf  /etc/sysctl.conf.sys
	mv ./sysctl.conf /etc/

	echo "\n"
        echo "\n"
        echo "\n"	
	cat /etc/security/limits.conf
	echo "limits.conf -> /etc/security/"
	sleep 5
	cp  /etc/security/limits.conf  /etc/security/limits.conf.sys
	mv ./limits.conf /etc/security/
	
	echo "\n"
        echo "\n"
        echo "\n"
	cat /etc/crontab
	echo "crontab -> /etc/"
	sleep 5
	cp  /etc/crontab  /etc/crontab.sys
	mv ./crontab	  /etc/

	echo "\n"
        echo "\n"
        echo "\n"	
	#安装log清理脚本
	echo "check_log.sh->/usr/local/dingtone/"
	mv ./check_log.sh $BIN_DIR
	ls $BIN_DIR/check_log.sh -l 

	echo "\n"
        echo "\n"
        echo "\n"	
	echo "install tcp bbr"
	mv ./tcpcong.modules /etc/sysconfig/modules/ 
	ls /etc/sysconfig/modules/tcpcong.modules
	sysctl net.ipv4.tcp_available_congestion_control
	sysctl net.ipv4.tcp_congestion_control
	lsmod | grep bbr

 	echo "\n"
        echo "\n"
        echo "\n"
        echo "config tun"
        mv ./tun.modules /etc/sysconfig/modules/
        ls /etc/sysconfig/modules/tun.modules
	lsmod | grep tun

	#update to latest linux kernel
	#rpm --import https://www.elrepo.org/RPM-GPG-KEY-elrepo.org
	#rpm -Uvh http://www.elrepo.org/elrepo-release-7.0-2.el7.elrepo.noarch.rpm
	#yum --enablerepo=elrepo-kernel install kernel-ml -y
	#grub2-set-default 0

        echo "\n"
        echo "\n"
        echo "\n"
	#install TzPingServer	
	#sh ./ping_update.sh
	
	rm -f ./install-xedge-vpn.zip

  
if [ -s /etc/selinux/config ]; then
    setenforce 0
    sed -i 's/^SELINUX=.*/SELINUX=disabled/g' /etc/selinux/config

    systemctl disable firewalld
    systemctl stop firewalld
#    systemctl disable iptables
#    systemctl stop iptables
fi

#curl -k -s -u admin:wxY8fk1#   -o /usr/local/dingtone/xedge  https://ops.up-gram.com/xedge/xedge-1.1.70
#chmod  755 /usr/local/dingtone/xedge

sed -i '/^#Port/c Port 1022' /etc/ssh/sshd_config
systemctl restart sshd
setenforce 0



echo "please double check /etc/sysctl.conf.sys "
echo "please double check /etc/security/limits.conf.sys"
echo "please double check /usr/local/dingtone/check_log.sh"
echo "please double check /etc/crontab.sys"
echo "please config ssh ACL at /etc/hosts.allow and /etc/hosts.deny if dont have firewall"

echo "iperf -s -u  -p 500"
echo "iperf -u -c xxx  -r -i 1 -t 3  -p 500 -b 240M" 
echo "please reboot"
