#! /bin/sh

#use sample(without sudo): ./update.sh  md5

# if [ $# != 1 ]; then
#     echo "You need pass md5sum as paramter!"
#     exit;
# fi

PING_SERVER_HOME=~/ping_server
ProgramName=RouteMonitor.tar.gz
echo "PING_SERVER_HOME=${PING_SERVER_HOME}"
echo "ProgramName=${ProgramName}"
BACKUP_DIR=$PING_SERVER_HOME/backup
echo "BACKUP_DIR=${BACKUP_DIR}"

if [ ! -d "$PING_SERVER_HOME" ]; then
  echo "mkdir ${PING_SERVER_HOME}"
  mkdir $PING_SERVER_HOME
fi

if [ ! -d "$BACKUP_DIR" ]; then
  echo "mkdir ${BACKUP_DIR}"
  mkdir $BACKUP_DIR
fi

DOWNLOAD_SOURCE_SERVER=root@169.54.140.196
echo "DOWNLOAD_SOURCE_SERVER=${DOWNLOAD_SOURCE_SERVER}"

#backup old edge binary
serverDate=$(ls -hl --time-style=long-iso $PING_SERVER_HOME/${ProgramName} | awk '{print $6}')
oldServerMd5Sum=$1 
mv $PING_SERVER_HOME/${ProgramName} $BACKUP_DIR/${ProgramName}.$serverDate
rm -f $PING_SERVER_HOME/${ProgramName}

#get the latest edge binary
scp $DOWNLOAD_SOURCE_SERVER:~/deploy/${ProgramName} $PING_SERVER_HOME/${ProgramName}

# unzip files
sudo cp $PING_SERVER_HOME/${ProgramName} /usr/local/dingtone/${ProgramName}
cd /usr/local/dingtone
tarName=/usr/local/dingtone/RouteMonitor.tar
rm -f ${tarName}
gunzip ${tarName}.gz
tar xvf ${tarName}   

sh /usr/local/dingtone/linux/restart-ping.sh

#newServerMd5Sum=$(md5sum $PING_SERVER_HOME/edge | awk '{print $1}')
# if [ "$oldServerMd5Sum" == "$newServerMd5Sum" ]; then
    # sudo service dingtone-edge stop
    # sudo mv /usr/local/dingtone/edge /usr/local/dingtone/edge.$serverDate
    # sudo cp $PING_SERVER_HOME/edge /usr/local/dingtone/edge
   # sudo service dingtone-edge start
# else
#     echo "Server update failed, wanted md5sum is: $oldServerMd5Sum, but now is: $newServerMd5Sum!"
#     mv $PING_SERVER_HOME/edge.$serverDate $PING_SERVER_HOME/edge
# fi                    
